/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.throwable.Coerce;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.Migration;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslEntryInfo;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CategoryBuilderImpl<Builder extends CategoryBuilderImpl<Builder>>
implements CategoryBuilder<Builder> {
    public final List<CategoryBuilder<?>> categories = new LinkedList();
    public final String id;
    public final String categoryPath;
    public final List<EntryInfo<?>> entries = new LinkedList();
    public final Map<String, Consumer<ConfigCategory>> presets = new LinkedHashMap<String, Consumer<ConfigCategory>>();
    public final List<Supplier<List<ConfigInstance>>> referencedConfigs = new LinkedList<Supplier<List<ConfigInstance>>>();
    public final List<Consumer<ConfigCategory>> verifiers = new LinkedList<Consumer<ConfigCategory>>();
    public final Map<String, Consumer<SerializeReader>> migrations = new LinkedHashMap<String, Consumer<SerializeReader>>();
    private boolean built = false;

    public CategoryBuilderImpl(String id, String categoryPath) {
        this.id = id;
        this.categoryPath = categoryPath;
        this.addPreset("libjf-config-core-v2.default", ConfigCategory::reset);
    }

    @Override
    public Builder addPreset(String id, Consumer<ConfigCategory> action) {
        this.checkBuilt();
        if (this.presets.containsKey(id)) {
            LibJf.LOGGER.warn("Duplicate preset registered for " + this.categoryPath + this.id + ": " + id + ", overriding", new Object[0]);
        }
        this.presets.put(id, action);
        return this.asBuilder();
    }

    @Override
    public Builder addPreset(String id, Runnable preset) {
        return (Builder)this.addPreset(id, cfg -> preset.run());
    }

    @Override
    public Builder removePreset(String id) {
        this.checkBuilt();
        if (this.presets.remove(id) == null) {
            throw new NoSuchElementException();
        }
        return this.asBuilder();
    }

    @Override
    public Builder addVerifier(Consumer<ConfigCategory> verifier) {
        this.checkBuilt();
        this.verifiers.add(verifier);
        return this.asBuilder();
    }

    @Override
    public Builder addVerifier(Runnable verifier) {
        return (Builder)this.addVerifier(cfg -> verifier.run());
    }

    @Override
    public Builder referenceConfig(String id) {
        return (Builder)this.referenceConfig(() -> List.of(ConfigHolder.getInstance().get(id)));
    }

    @Override
    public Builder referenceConfig(ConfigInstance config) {
        return (Builder)this.referenceConfig(() -> List.of(config));
    }

    @Override
    public Builder referenceConfig(Supplier<List<ConfigInstance>> gen) {
        this.checkBuilt();
        this.referencedConfigs.add(Objects.requireNonNull(gen));
        return this.asBuilder();
    }

    @Override
    public Builder category(String id, CategoryBuilder.CategoryBuilderFunction builder) {
        this.checkBuilt();
        this.categories.add(builder.apply(new CategoryBuilderImpl<Builder>(id, this.categoryPath + id + ".")));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, int def, double min, double max, Supplier<Integer> get, Consumer<Integer> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<Integer>(id, def, get::get, set::accept, Type.TInt.INSTANCE, 100, min, max));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, long def, double min, double max, Supplier<Long> get, Consumer<Long> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<Long>(id, def, get::get, set::accept, Type.TLong.INSTANCE, 100, min, max));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, float def, double min, double max, Supplier<Float> get, Consumer<Float> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<Float>(id, Float.valueOf(def), get::get, set::accept, Type.TFloat.INSTANCE, 100, min, max));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, double def, double min, double max, Supplier<Double> get, Consumer<Double> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<Double>(id, def, get::get, set::accept, Type.TDouble.INSTANCE, 100, min, max));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, String def, Supplier<String> get, Consumer<String> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<String>(id, def, get::get, set::accept, Type.TString.INSTANCE));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, boolean def, Supplier<Boolean> get, Consumer<Boolean> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<Boolean>(id, def, get::get, set::accept, Type.TBool.INSTANCE));
        return this.asBuilder();
    }

    @Override
    public Builder value(String id, String def, String[] options, Supplier<String> get, Consumer<String> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<String>(id, def, get::get, set::accept, Type.TEnum.create(id, options)));
        return this.asBuilder();
    }

    @Override
    public <T extends Enum<T>> Builder value(String id, T def, Class<T> klazz, Supplier<T> get, Consumer<T> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<T>(id, def, get::get, set::accept, new Type.TEnum<T>(klazz)));
        return this.asBuilder();
    }

    @Override
    public <T> Builder value(String id, T def, double min, double max, Type type, int width, Supplier<T> get, Consumer<T> set) {
        this.checkBuilt();
        this.entries.add(new DslEntryInfo<T>(id, def, get::get, set::accept, type, width, min, max));
        return this.asBuilder();
    }

    @Override
    public <T> Builder value(EntryInfo<T> entry) {
        this.checkBuilt();
        this.entries.add(Objects.requireNonNull(entry));
        return this.asBuilder();
    }

    @Override
    public Builder addMigration(String element, Migration migration) {
        this.checkBuilt();
        if (this.migrations.containsKey(element)) {
            LibJf.LOGGER.warn("Duplicate migration registered for " + this.categoryPath + this.id + ": " + element + ", overriding", new Object[0]);
        }
        this.migrations.put(element, Coerce.consumer(migration::apply).addHandler(e -> LibJf.LOGGER.error("Could not apply migration for " + element, e)));
        return this.asBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected Builder asBuilder() {
        return (Builder)this;
    }

    protected void checkBuilt() {
        if (this.built) {
            throw new IllegalStateException("This builder was already used to build a category!");
        }
    }

    protected void markBuilt() {
        this.checkBuilt();
        this.built = true;
    }

    @Override
    public DslConfigCategory build(Supplier<ConfigInstance> root) {
        this.markBuilt();
        Set<String> migrationNames = this.migrations.keySet();
        HashSet<String> entryNames = new HashSet<String>();
        for (EntryInfo<?> entry : this.entries) {
            String name = entry.getName();
            if (migrationNames.contains(name)) {
                LibJf.LOGGER.warn("Entry conflict: " + this.categoryPath + this.id + " contains both a migration and an entry for " + name, new Object[0]);
            }
            if (entryNames.add(name)) continue;
            LibJf.LOGGER.warn("Entry conflict: " + this.categoryPath + this.id + " contains two entries for " + name, new Object[0]);
        }
        HashSet<String> categoryNames = new HashSet<String>();
        for (CategoryBuilder<?> category : this.categories) {
            String name = category.getId();
            if (migrationNames.contains(name)) {
                LibJf.LOGGER.warn("Entry conflict: " + this.categoryPath + this.id + " contains both a migration and a category for " + name, new Object[0]);
            }
            if (entryNames.contains(name)) {
                LibJf.LOGGER.warn("Entry conflict: " + this.categoryPath + this.id + " contains both an entry and a category for " + name, new Object[0]);
            }
            if (categoryNames.add(name)) continue;
            LibJf.LOGGER.warn("Entry conflict: " + this.categoryPath + this.id + " contains two categories for " + name, new Object[0]);
        }
        return new DslConfigCategory(this.id, this.entries, this.presets, this.referencedConfigs, this.categories, root, this.verifiers, this.migrations);
    }
}

